<?php
/**
 * AddAccessToGroup.
 * php version 5.6
 *
 * @category AddAccessToGroup
 * @package  SureTriggers
 * @author   BSF <username@example.com>
 * @license  https://www.gnu.org/licenses/gpl-3.0.html GPLv3
 * @link     https://www.brainstormforce.com/
 * @since    1.0.0
 */

namespace SureTriggers\Integrations\SureMembers\Actions;

use SureMembers\Inc\Helper;
use SureTriggers\Integrations\AutomateAction;
use SureTriggers\Integrations\WordPress\WordPress;
use SureTriggers\Traits\SingletonLoader;

/**
 * AddAccessToGroup
 *
 * @category AddAccessToGroup
 * @package  SureTriggers
 * @author   BSF <username@example.com>
 * @license  https://www.gnu.org/licenses/gpl-3.0.html GPLv3
 * @link     https://www.brainstormforce.com/
 * @since    1.0.0
 */
class AddAccessToGroup extends AutomateAction {

	/**
	 * Integration type.
	 *
	 * @var string
	 */
	public $integration = 'SureMembers';

	/**
	 * Action name.
	 *
	 * @var string
	 */
	public $action = 'add_access_to_group';

	use SingletonLoader;

	/**
	 * Register a action.
	 *
	 * @param array $actions actions.
	 * @return array
	 */
	public function register( $actions ) {
		$actions[ $this->integration ][ $this->action ] = [
			'label'    => __( 'Add User to Access Group', 'suretriggers' ),
			'action'   => $this->action,
			'function' => [ $this, 'action_listener' ],
		];
		return $actions;
	}

	/**
	 * Action listener.
	 *
	 * @param int   $user_id user_id.
	 * @param int   $automation_id automation_id.
	 * @param array $fields fields.
	 * @param array $selected_options selectedOptions.
	 * @psalm-suppress UndefinedMethod
	 *
	 * @return array|bool|void
	 */
	public function _action_listener( $user_id, $automation_id, $fields, $selected_options ) {
		if ( ! class_exists( 'SureMembers\Inc\Helper' ) ) {
			return [
				'status'  => 'error',
				'message' => __( 'SureMembers Helper class not found', 'suretriggers' ), 
				
			];
		}
		if ( ! $user_id ) {
			return [
				'status'  => 'error',
				'message' => __( 'User Not found', 'suretriggers' ), 
				
			];
		}
		$access_group_id = $selected_options['st_add_access_group'];

		if ( empty( $access_group_id ) ) {
			return;
		}

		$helper = new Helper();
		$helper->grant_access( $user_id, $access_group_id );

		$context['group'] = WordPress::get_post_context( $access_group_id );
		return $context;
	}

}

AddAccessToGroup::get_instance();
